/*
 * Decompiled with CFR 0.152.
 */
package moe.score.pishockzap.pishockapi;

import java.util.Objects;
import java.util.Random;
import java.util.logging.Logger;
import lombok.NonNull;
import moe.score.pishockzap.config.ShockDistribution;

public final class PiShockUtils {
    public static final int PISHOCK_MAX_DURATION = 15;
    public static final int PISHOCK_MAX_INTENSITY = 100;
    private static final Logger logger = Logger.getLogger(PiShockUtils.class.getName());

    public static boolean shockParamsAreValid(int intensity, float duration) {
        if (intensity == 0 || duration == 0.0f) {
            return false;
        }
        if (intensity < 0 || intensity > 100) {
            logger.warning("PiShock intensity out of range: " + intensity);
            return false;
        }
        if (duration < 0.0f || duration > 15.0f) {
            logger.warning("PiShock duration out of range: " + duration);
            return false;
        }
        return true;
    }

    private PiShockUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class ShockDistributor {
        private int roundRobinIndex = 0;
        private final Random random = new Random();

        public boolean @NonNull [] pickShockers(@NonNull ShockDistribution distribution, int length) {
            Objects.requireNonNull(distribution, "distribution is marked non-null but is null");
            boolean[] shocks = new boolean[length];
            int randomIndex = this.random.nextInt(length);
            if (this.roundRobinIndex >= length) {
                this.roundRobinIndex = 0;
            }
            for (int i = 0; i < length; ++i) {
                shocks[i] = switch (distribution) {
                    default -> throw new IncompatibleClassChangeError();
                    case ShockDistribution.ALL -> true;
                    case ShockDistribution.ROUND_ROBIN -> {
                        if (i == this.roundRobinIndex) {
                            yield true;
                        }
                        yield false;
                    }
                    case ShockDistribution.RANDOM -> {
                        if (i == randomIndex) {
                            yield true;
                        }
                        yield false;
                    }
                    case ShockDistribution.RANDOM_ALL -> this.random.nextBoolean();
                    case ShockDistribution.FIRST -> {
                        if (i == 0) {
                            yield true;
                        }
                        yield false;
                    }
                    case ShockDistribution.LAST -> i == shocks.length - 1;
                };
            }
            ++this.roundRobinIndex;
            if (distribution == ShockDistribution.RANDOM_ALL) {
                boolean hasShock = false;
                for (boolean shock : shocks) {
                    if (!shock) continue;
                    hasShock = true;
                    break;
                }
                if (!hasShock) {
                    shocks[randomIndex] = true;
                }
            }
            return shocks;
        }
    }
}

